<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Role;
use App\Models\Admin\Website;
use App\Models\ScriptForSite;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ScriptForSiteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $title = 'Custom Script';
        $datas = ScriptForSite::all();
        $website = Website::latest()->first();
        return view('backend.pages.system-setting.script-for-script', compact('datas', 'website', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required',
            'script' => 'required',
        ]);

        $data = new ScriptForSite();
        $data->type = $request->input('type');
        $data->script = $request->input('script');
        $data->save();

        return redirect()->back()->with('message','Data Successfully Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'type' => 'required',
            'script' => 'required',
        ]);

        $data = ScriptForSite::find($id);
        $data->type = $request->input('type');
        $data->script = $request->input('script');
        $data->save();

        return redirect()->back()->with('message','Data Successfully Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = ScriptForSite::find($id);
        $data->delete();

        return redirect()->back()->with('message','Data Successfully Deleted');
    }
}
